#include <iostream>
#include <set>
#include <tuple>
#include <vector>
using namespace std;

struct Interval {
  int l, r, id;

  friend bool operator < (const Interval& a, const Interval& b) {
    return make_tuple(a.l, a.r, a.id) < make_tuple(b.l, b.r, b.id);
  }
};

const int MAXN = 100100;

int n, d;
vector<int> adj[MAXN];
set<Interval> S;

void Update(Interval inv) {
  vector<Interval> iters;
  auto it = S.lower_bound(inv);
  if (it != S.begin()) it--;
  for (; it != S.end() && it->l < inv.r; it++) {
    if (it->r > inv.l)
      iters.push_back(*it);
  }
  for (Interval iter : iters) {
    adj[iter.id].push_back(inv.id);
    S.erase(iter);
    if (iter.l < inv.l) S.insert({iter.l, inv.l, iter.id});
    if (iter.r > inv.r) S.insert({inv.r, iter.r, iter.id});
  }
  S.insert(inv);
}

int Solve(int x) {
  static int memo[MAXN];
  if (x == n) return 0;
  if (memo[x]) return memo[x];
  int mn = MAXN;
  for (int y : adj[x])
    mn = min(mn, Solve(y));
  return memo[x] = 1 + mn;
}

int main(void) {
  cin >> n >> d;
  for (int i = 0; i < n; ++i) {
    int l, r;
    cin >> l >> r;
    Update({l, r, i});
  }
  Update({0, d, n});
  cout << Solve(0) << endl;
  return 0;
}
